<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use App\Http\Requests;
//use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Auth;
use Validator;
use Hash;
use Redirect;
use DB;
use Session;

class MainController extends Controller {

    public function login(Request $request) {
        if (Auth:: attempt([
                    'email' => $request->email,
                    'password' => $request->password
                ])) {
            $user = User::where('email', $request->email)->first();

            if ($user->is_admin()) {
                if ($user->is_active()) {
                        return redirect('admin/dashboard');
                   
                } else {
                    
                    return redirect()->back()->with('message1', 'Email Or Password Invalid');
                }
            } else {

                if ($user['status']==1) {
                    
                   
                    if($user['status']==1){
                        return redirect('/');
                    } else {
                        Session::flush();
                        return redirect()->back()->with('message1', 'Your application is under review!');
                    }
                    
                } else {
                    return redirect()->back()->with('message1', 'Email Or Password Invalid');
                }
            }
            
        } else {
            return redirect()->back()->with('message1', 'Email Or Password Invalid');
        }
    }

    public function register(Request $request) {
        $validation = array(
            'name' => 'required|max:255',
            'email' => 'required|unique:users',
            'password' => 'required|min:4',
            'cpassword' => 'required|same:password'
        );

        $validator = Validator::make($request->all(), $validation);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
            echo"validate fails";
        } else {
            
            $user = new User;
            $user->name = $request->input('name');
            $user->email = $request->input('email');
            $user->password = Hash::make($request->input('password'));
            $user->save();
            
            $to = $request->input('email');
            $subject = "You have Registered!";
            $txt = "THANKYOU! Your application is under review.";
            $headers = "From: zaid.ansa@gmail.com" . "\r\n" ."CC: zahid@golpik.com";

            mail($to,$subject,$txt,$headers);
            
            return redirect('welcome');//->back()->with('message', 'Thanks! Your Application is Under Review');
        }
    }

}
