<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use App\General;
use App\Prices;
use App\Details;
use Validator,
    Input,
    Redirect,
    Session,
    Config,
    File,
    Mail;
use Auth;
use App\User;
use View;
use App\Subscriber;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function Home(Request $request)
    {
        if (Auth::guest()){  
        } else {
            $role_id = isset(Auth::user()->admin);
            if($role_id==0)
            {
                return redirect('admin/dashboard');
            }
        }    
        
        $Types = Session::get('types');
        $sort = $request->input('cats');
        
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                //->where('productType',$Types)
            ->paginate(15);
        return view('front.home', compact('productslist','sort','Types'));
    }
    
    public function Search(Request $request)
    {
        $Types = Session::get('types');
        Session::put('q',trim($_GET['q']," "));
        $q=trim($_GET['q']," ");
        
        $key=explode("#",$_GET['q']);
        
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate');
               if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $productslist = $productslist->where('customerStyleNumber', '=', trim($key[1]," "));
                        $productslist = $productslist->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $productslist = $productslist->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
            $productslist = $productslist->paginate(15);
        
        return view('front.search_detail', compact('productslist','q','Types'));
    }
    
    public function Subscribe(Request $request){
        
	$rules = array('subscribe' => 'required|email|unique:subscriber|max:255');
        $validator = Validator::make($request->all(), $rules);

	if ($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
	} else {
            $Subscriber = new Subscriber;
            $Subscriber->subscribe = $request->input('subscribe');
            $Subscriber->active = 1;
            $Subscriber->created_at = date("Y-m-d");
            $Subscriber->updated_at = date("Y-m-d");
            $Subscriber->save();
            return redirect()->back()->with('message1','Successfully');
	}
    }

        public function Details($stylenum)
    {
      
        $Types = Session::get('types');
        //$sort = $request->input('cats');
        
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                ->where('lpdGeneral.styleNumber',$stylenum)
            ->paginate(15);
        
        $related_list = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                ->where('lpdGeneral.companyName',$productslist[0]->companyName)
                ->inRandomOrder()
            ->paginate(15);
        
        return view('front.detail', compact('productslist','sort','Types','related_list'));
    }
    
    public function productlist(Request $request,$types)
    {
      
        Session::put('types',$types);
        $Types = Session::get('types');
        $sort = $request->input('cats');
        
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                ->where('productType',$Types)
            ->paginate(15);
        
        return view('front.products', compact('productslist','sort','Types'));
    }
    
     
    public function result(Request $request) {
        
        if(isset($_GET['q'])){
            $q=trim($_GET['q']," ");
            $key=explode("#",$_GET['q']);
        }
        
        $Types = Session::get('types');
        if (Auth::guest()){
            $per = 0;
            $amount = 0;
        }else{
            if (Auth::user()->active==1){
                $per = Auth::user()->markup_per;
                $amount = Auth::user()->markup_amount;
            } else {
                $per = 0;
                $amount = 0;
            }
        }
        $price_limit = General::getPriceLimit($Types);
     
        if($price_limit['s_max'] >= $price_limit['ys_max']){
            $max_price=ceil($price_limit['s_max']);
        }
        if($price_limit['ys_max'] >= $price_limit['s_max']){
            $max_price=ceil($price_limit['ys_max']);
        }

        if($price_limit['s_min'] >= $price_limit['ys_min']){
            $min_price=round($price_limit['s_min']);
        }
        if($price_limit['ys_min'] >= $price_limit['s_min']){
            $min_price=round($price_limit['ys_min']);
        }
        
        $tag='';
        $typ='';
        $p_min = 0;
        $p_max = 0;
        $tags = $request->input('tags');
        $type = $request->input('type');
        $fabric = $request->input('fabric');
        $color = $request->input('color');
        $style = $request->input('style');
        $sizes = $request->input('sizes');
        $brand = $request->input('brand');
        $sort = $request->input('sort');
        $p_min = $request->input('p_min');
        $p_max = $request->input('p_max');
        
        //var_dump($p_min.'<br/>'.$p_max);
       // print_r($p_max);
        /*if($p_min != 0){
            $p_mins = General::getMarkupSub($per,$amount,$min_price);//$request->input('p_min');
            $p_min=$p_min-$p_mins;
        }
         if($p_max != 0){
            $p_maxs = General::getMarkupSub($per,$amount,$max_price);//$request->input('p_max');
            $p_max=$p_max-$p_maxs;
        }
        */
        $search['tags']=$tags;
        $search['type']=$type;
        $search['fabric']=$fabric;
        $search['color']=$color;
        $search['style']=$style;
        $search['sizes']=$sizes;
        $search['brand']=$brand;
        $search['sort']=$sort;
        $search['p_min']=$p_min;
        $search['p_max']=$p_max;
        //print_r($p_min);
       // print_r($p_max);
        
        
        $youth_S=array();
        $_S=array();
       
        // For Price youthS
        $youth_S = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS' ,'lpdPrices.youthS' ,'lpdPrices.youthM' ,'lpdPrices.youthL' ,'lpdPrices.youthXL' ,'lpdPrices.XS' ,'lpdPrices.S' ,'lpdPrices.M' ,'lpdPrices.L' ,'lpdPrices.XL' ,'lpdPrices.2XL as twoxl' ,'lpdPrices.3XL as threexl' ,'lpdPrices.4XL as fourthxl' ,'lpdPrices.5XL as fivexl' ,'lpdPrices.lastPriceUpdate' ,'lpdPrices.daysSinceLastUpdate');
            if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $youth_S = $youth_S->where('customerStyleNumber', '=', trim($key[1]," "));
                        $youth_S = $youth_S->where('companyName', '=',  trim($key[0]," "));
                    }else {
                        $youth_S = $youth_S->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                } else { $youth_S = $youth_S->where('productType',$Types); }
            if(isset($search['tags']) && $search['tags']!="") 
            {  $youth_S = $youth_S->whereIn('productCategory',$search['tags']); }
            if(isset($search['type']) && $search['type']!="") 
            { $youth_S = $youth_S->whereIn('productType',$search['type']); }
            if(isset($search['fabric']) && $search['fabric']!="") 
            { $youth_S = $youth_S->whereIn('materials',$search['fabric']);  }
            if(isset($search['color']) && $search['color']!="") 
            { $youth_S = $youth_S->whereIn('colors',$search['color']); }
            if(isset($search['brand']) && $search['brand']!="") 
            { $youth_S = $youth_S->whereIn('factory',$search['brand']); } 
            if(isset($search['style']) && $search['style']!="") 
            {  $youth_S = $youth_S->whereIn('productDetail',$search['style']);  }
            if(isset($search['sizes']) && $search['sizes']!="") 
            {
                if(in_array("youthXS", $search['sizes']))
                        { $youth_S = $youth_S->where('youthXS','<>', ''); }
                if(in_array("youthS", $search['sizes']))
                        {  $youth_S = $youth_S->where('youthS','<>', ''); }
                if(in_array("youthM", $search['sizes']))
                        {  $youth_S = $youth_S->where('youthM','<>', ''); }
                if(in_array("youthL", $search['sizes']))
                        {  $youth_S = $youth_S->where('youthL','<>', '');  }
                if(in_array("youthXL", $search['sizes']))
                        {  $youth_S = $youth_S->where('youthXL','<>', ''); }
                if(in_array("XS", $search['sizes']))
                        { $youth_S = $youth_S->where('XS','<>', ''); }
                if(in_array("S", $search['sizes']))
                        { $youth_S = $youth_S->where('S','<>', '');  }
                if(in_array("M", $search['sizes']))
                        { $youth_S = $youth_S->where('M','<>', ''); }
                if(in_array("L", $search['sizes']))
                        { $youth_S = $youth_S->where('L','<>', ''); }
                if(in_array("XL", $search['sizes']))
                        {  $youth_S = $youth_S->where('XL','<>', ''); }
                if(in_array("2XL", $search['sizes']))
                        {  $youth_S = $youth_S->where('2XL','<>', ''); }
                if(in_array("3XL", $search['sizes']))
                        {  $youth_S = $youth_S->where('3XL','<>', ''); }
                if(in_array("4XL", $search['sizes']))
                        { $youth_S = $youth_S->where('4XL','<>', '');  }
                if(in_array("5XL", $search['sizes']))
                        { $youth_S = $youth_S->where('5XL','<>', ''); }
            }
            
            if(($p_min >= 0) && ($p_max > 0)){
                //$youth_S = $youth_S->whereBetween('youthS',array(round($p_min).'.10',round($p_max).'.90'));
                $youth_S = $youth_S->whereRaw('concat(round(('.$per.'/100) * lpdPrices.youthS + lpdPrices.youthS,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

               
            }
            
            if(isset($search['sort']) && $search['sort']!="") 
            {
                 $youth_S = $youth_S->orderBy('companyName',$search['sort']);
            }
            $youth_S=  $youth_S->groupBy('lpdPrices.styleNumber');      
            $youth_S=  $youth_S->get();
            
            
               
        //--------------------------------------------------------------------------------
        
        // For Price S
        $_S = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS','lpdPrices.youthS' ,'lpdPrices.youthM' ,'lpdPrices.youthL','lpdPrices.youthXL' ,'lpdPrices.XS' ,'lpdPrices.S' ,'lpdPrices.M' ,'lpdPrices.L' ,'lpdPrices.XL' ,'lpdPrices.2XL as twoxl' ,'lpdPrices.3XL as threexl' ,'lpdPrices.4XL as fourthxl' ,'lpdPrices.5XL as fivexl' ,'lpdPrices.lastPriceUpdate' ,'lpdPrices.daysSinceLastUpdate');
            if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $_S = $_S->where('customerStyleNumber', '=', trim($key[1]," "));
                        $_S = $_S->where('companyName', '=',  trim($key[0]," "));
                    }else {
                        $_S = $_S->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                } else { $_S = $_S->where('productType',$Types); }
                
            if(isset($search['tags']) && $search['tags']!="") 
                { $_S = $_S->whereIn('productCategory',$search['tags']); }
            if(isset($search['type']) && $search['type']!="") 
                { $_S = $_S->whereIn('productType',$search['type']); }            
            if(isset($search['fabric']) && $search['fabric']!="") 
                {  $_S = $_S->whereIn('materials',$search['fabric']); }
            if(isset($search['color']) && $search['color']!="") 
                { $_S = $_S->whereIn('colors',$search['color']); }
            if(isset($search['brand']) && $search['brand']!="")  
                { $_S = $_S->whereIn('factory',$search['brand']); }            
            if(isset($search['style']) && $search['style']!="")  
                { $_S = $_S->whereIn('productDetail',$search['style']); }
            if(isset($search['sizes']) && $search['sizes']!="") 
            {
                if(in_array("youthXS", $search['sizes']))
                        { $_S = $_S->where('youthXS','<>', ''); }
                if(in_array("youthS", $search['sizes']))
                        { $_S = $_S->where('youthS','<>', ''); }
                if(in_array("youthM", $search['sizes']))
                        { $_S = $_S->where('youthM','<>', ''); }
                if(in_array("youthL", $search['sizes']))
                        { $_S = $_S->where('youthL','<>', '');  }
                if(in_array("youthXL", $search['sizes']))
                        { $_S = $_S->where('youthXL','<>', ''); }
                if(in_array("XS", $search['sizes']))
                        { $_S = $_S->where('XS','<>', ''); }
                if(in_array("S", $search['sizes']))
                        { $_S = $_S->where('S','<>', ''); }
                if(in_array("M", $search['sizes']))
                        { $_S = $_S->where('M','<>', ''); }
                if(in_array("L", $search['sizes']))
                        { $_S = $_S->where('L','<>', ''); }
                if(in_array("XL", $search['sizes']))
                        { $_S = $_S->where('XL','<>', '');  }
                if(in_array("2XL", $search['sizes'])
                        ){ $_S = $_S->where('2XL','<>', ''); }
                if(in_array("3XL", $search['sizes']))
                        { $_S = $_S->where('3XL','<>', ''); }
                if(in_array("4XL", $search['sizes']))
                        { $_S = $_S->where('4XL','<>', '');}
                if(in_array("5XL", $search['sizes']))
                        { $_S = $_S->where('5XL','<>', ''); }
            }
            
            if(($p_min >= 0) && ($p_max > 0)){  
               
                //$_S = $_S->WhereBetween('S',array(round($p_min).'.10',round($p_max).'.90'));
                $_S = $_S->whereRaw('concat(round(('.$per.'/100) * lpdPrices.S + lpdPrices.S,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

                
            }
            
            if(isset($search['sort']) && $search['sort']!="") 
                { $_S = $_S->orderBy('companyName',$search['sort']); }
            $_S=  $_S->groupBy('lpdPrices.styleNumber');      
            $_S=  $_S->get(); 
            
              
        //--------------------------------------------------------------------------------
        
          
        // ~~~~~~~~~~~~~~~~~~ Main Query ~~~~~~~~~~~~~~~~~~~~~~~~~~`    
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'  ,'lpdPrices.youthS' ,'lpdPrices.youthM' ,'lpdPrices.youthL' ,'lpdPrices.youthXL' ,'lpdPrices.XS' ,'lpdPrices.S' ,'lpdPrices.M' ,'lpdPrices.L' ,'lpdPrices.XL' ,'lpdPrices.2XL as twoxl' ,'lpdPrices.3XL as threexl' ,'lpdPrices.4XL as fourthxl'  ,'lpdPrices.5XL as fivexl' ,'lpdPrices.lastPriceUpdate' ,'lpdPrices.daysSinceLastUpdate'
                    ,DB::raw('concat(round(('.$per.'/100) * lpdPrices.S + '.$amount.' + lpdPrices.S,2)) as sMarkup')
                    ,DB::raw('concat(round(('.$per.'/100) * lpdPrices.youthS + '.$amount.' + lpdPrices.youthS,2)) as ysMarkup'));    
        
            if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $productslist = $productslist->where('customerStyleNumber', '=', trim($key[1]," "));
                        $productslist = $productslist->where('companyName', '=',  trim($key[0]," "));
                    }else {
                        $productslist = $productslist->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                } else {  $productslist = $productslist->where('productType',$Types); }
            if(isset($search['tags']) && $search['tags']!="") 
            { $productslist = $productslist->whereIn('productCategory',$search['tags']); }
            if(isset($search['type']) && $search['type']!="") 
            { $productslist = $productslist->whereIn('productType',$search['type']); } 
            if(isset($search['fabric']) && $search['fabric']!="") 
            {  $productslist = $productslist->whereIn('materials',$search['fabric']); }
            if(isset($search['color']) && $search['color']!="") 
            { $productslist = $productslist->whereIn('colors',$search['color']); }
            if(isset($search['brand']) && $search['brand']!="") 
            { $productslist = $productslist->whereIn('companyName',$search['brand']);  } 
            if(isset($search['style']) && $search['style']!="") 
            { $productslist = $productslist->whereIn('productDetail',$search['style']);  }
            
            if(isset($search['sizes']) && $search['sizes']!="") {
                if(in_array("youthXS", $search['sizes'])){
                    $productslist = $productslist->where('youthXS','<>', '');
                }
                if(in_array("youthS", $search['sizes'])){
                    $productslist = $productslist->where('youthS','<>', '');
                }
                if(in_array("youthM", $search['sizes'])){
                    $productslist = $productslist->where('youthM','<>', '');
                }
                if(in_array("youthL", $search['sizes'])){
                    $productslist = $productslist->where('youthL','<>', '');
                }
                if(in_array("youthXL", $search['sizes'])){
                    $productslist = $productslist->where('youthXL','<>', '');
                }
                if(in_array("XS", $search['sizes'])){
                    $productslist = $productslist->where('XS','<>', '');
                }
                if(in_array("S", $search['sizes'])){
                    
                    $productslist = $productslist->where('S','<>', '');
                }
                if(in_array("M", $search['sizes'])){
                    $productslist = $productslist->where('M','<>', '');
                }
                if(in_array("L", $search['sizes'])){
                    $productslist = $productslist->where('L','<>', '');
                }
                if(in_array("XL", $search['sizes'])){
                    $productslist = $productslist->where('XL','<>', '');
                }
                if(in_array("2XL", $search['sizes'])){
                    $productslist = $productslist->where('2XL','<>', '');
                }
                if(in_array("3XL", $search['sizes'])){
                    $productslist = $productslist->where('3XL','<>', '');
                }
                if(in_array("4XL", $search['sizes'])){
                    $productslist = $productslist->where('4XL','<>', '');
                }
                if(in_array("5XL", $search['sizes'])){
                    $productslist = $productslist->where('5XL','<>', '');
                }
                
            }
            if(isset($search['sort']) && $search['sort']!="") {
            $orderSql = 'IF(lpdPrices.S != 0.00 || lpdPrices.S != "",sMarkup,YsMarkup)';
    
            if($search['sort']=='pasc'){
                    $productslist = $productslist->orderByRaw($orderSql.' asc');
                    //$productslist = $productslist->orderBy('youthS','asc');
                }
                elseif($search['sort']=='pdesc'){
                    $productslist = $productslist->orderByRaw($orderSql.' desc');
                    //$productslist = $productslist->orderBy('S','desc');
                    //$productslist = $productslist->orderBy('youthS','desc');
                } else {
                    $productslist = $productslist->orderBy('companyName',$search['sort']);
                }
            }
            if(($p_min >= 0) && ($p_max > 0)){
               $sql = 'IF(lpdPrices.S != 0,concat(round(('.$per.'/100) * lpdPrices.S + '.$amount.' + lpdPrices.S,2))
                       ,concat(round(('.$per.'/100) * lpdPrices.youthS + '.$amount.' + lpdPrices.youthS,2)))';

                $productslist = $productslist->whereRaw($sql.' BETWEEN '.$p_min.' AND '.$p_max.'');
                /*if(!empty($youth_S) || !empty($_S)) {
                    
                    if(!empty($youth_S) && !empty($_S)) {
                       
                         
                        //$productslist = $productslist->whereBetween('youthS',array($search['p_min'],$search['p_max']));
                        //$productslist = $productslist->whereBetween('S',array(round($p_min).'.10',round($p_max).'.90'));
                        $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.youthS + lpdPrices.youthS,2)) BETWEEN '.$p_min.' AND '.$p_max.'');
                        $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.S + lpdPrices.S,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

                    
                    }else{
                        
                        if( !empty($youth_S) ) {
                           
                            //$productslist = $productslist->whereBetween('youthS',array(round($p_min).'.10',round($p_max).'.90'));
                            $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.youthS + lpdPrices.youthS,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

                        }
                        if(!empty($_S)){
                             
                           //$productslist = $productslist->whereBetween('S',array(round($p_min).'.10',round($p_max).'.90'));
                           $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.S + lpdPrices.S,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

                        }
                    }  
                } else {
                        
                    //$productslist = $productslist->whereBetween('youthS',array(round($p_min).'.10',round($p_max).'.90'));
                    //$productslist = $productslist->whereBetween('S',array(round($p_min).'.10',round($p_max).'.90'));
                    $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.youthS + lpdPrices.youthS,2)) BETWEEN '.$p_min.' AND '.$p_max.'');
                    $productslist = $productslist->whereRaw('concat(round(('.$per.'/100) * lpdPrices.S + lpdPrices.S,2)) BETWEEN '.$p_min.' AND '.$p_max.'');

                }*/
                 
            }
            
           // var_dump($productslist);
            // die();
          $whereSql = 'IF(lpdPrices.S!=0.00,lpdPrices.S,lpdPrices.youthS)';  
          $productslist = $productslist->whereRaw($whereSql.' > 0');
          $productslist=  $productslist->groupBy('lpdGeneral.styleNumber','lpdPrices.styleNumber');
          $productslist=  $productslist->paginate(15);
          
        if ($request->ajax()) {
            return view('front.result',compact("productslist"))->render();  
        }
        
        
        return view('front.result',compact("productslist"));        
    }
    // detail page ajax call
    public function getImage(Request $request){
        
        $input = $request->all();
        $Types = Session::get('types');
        
        $productslist = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                ->where('lpdGeneral.styleNumber',$input['id'])
            ->get();
         $related_list = DB::table('lpdGeneral')
            ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
            ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
            ->select('lpdGeneral.*','lpdDetails.*','lpdPrices.youthXS'
                    ,'lpdPrices.youthS'
                    ,'lpdPrices.youthM'
                    ,'lpdPrices.youthL'
                    ,'lpdPrices.youthXL'
                    ,'lpdPrices.XS'
                    ,'lpdPrices.S'
                    ,'lpdPrices.M'
                    ,'lpdPrices.L'
                    ,'lpdPrices.XL'
                    ,'lpdPrices.2XL as twoxl'
                    ,'lpdPrices.3XL as threexl'
                    ,'lpdPrices.4XL as fourthxl'
                    ,'lpdPrices.5XL as fivexl'
                    ,'lpdPrices.lastPriceUpdate'
                    ,'lpdPrices.daysSinceLastUpdate')
                ->where('lpdGeneral.companyName',$productslist[0]->companyName)
                ->inRandomOrder()
            ->paginate(15);

        $ColorsInfo = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->where('lpdDetails.styleNumber',$input['id'])
                ->get();
        $Colorsdata['image1URL']=$ColorsInfo[0]->image1URL;
        $Colorsdata['styleNumber']=$ColorsInfo[0]->styleNumber;
        //return $Colorsdata;
        return view('front.ajax_detail', compact('productslist','Types','related_list'));
    }

        public function index()
    {
        return view('home');
    }
}
