<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Category;
use Validator,
    Input,
    Redirect;
use DB;
use App\User;
use Auth;

class AdminController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function adminindex() {
        $admin = Auth::user()->admin;
        if ($admin != 1) {
            return redirect('/');
        }

        return view('admin.index');
    }

    

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~USER~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    public function requestapp() {
        $admin = Auth::user()->admin;
        if ($admin != 1) {
            return redirect('/');
        }
        $getAlluserArr = DB::table('users')->where('active', '!=', -1)->where('admin', '!=', 1)->get();
        return view('admin.users.request')->with('userInfo', $getAlluserArr);
    }
    public function showAllUsers() {

        $admin = Auth::user()->admin;
        if ($admin != 1) {
            return redirect('/');
        }
        $getAlluserArr = DB::table('users')->where('status', '=', 1)->where('admin', '!=', 1)->get();
        return view('admin.users.showuser')->with('userInfo', $getAlluserArr);
    }

    public function editUser($id) {
        $getAlluserArr = DB::table('users')->where('id', '=', $id)->get();

        return view('admin.users.edit')->with('userInfo', $getAlluserArr);
    }

    public function editUserAction(Request $request) {

        $rules = array('id' => 'required');
        $id = $request->input('id');
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator->errors());
        } else {

            $updateArr = array('garment_identifies' => $request->input('garment_identifies'),
                'active' => $request->input('active'),
                'markup_per' => $request->input('markup_per'),
                'markup_amount' => $request->input('markup_amount')
            );
            $supRes = User::where('id', $id)->update($updateArr);

            if ($supRes) {
               
                echo 'user edit successfully';
                //return Redirect::action('AdminController@showAllUsers')->with('message', 'user edit successfully');
            } else {
                return redirect()->back()->withInput();
            }
        }
    }

    public function activeUser($id) {
        $updateArr = array('status' => '1');
        $supRes = User::where('id', $id)->update($updateArr);

        if ($supRes) {
             $getUserArr = DB::table('users')->where('id', '=', $id)->get();
                if ($getUserArr[0]->active == 1) {
                    $to = $getUserArr[0]->email;
                    $subject = "Your Application Approved";
                    $txt = "Your application Approved!";
                    $headers = "From: zaid.ansa@gmail.com" . "\r\n" . "CC: zahid@golpik.com";

                    mail($to, $subject, $txt, $headers);
                }
                 echo 'user edit successfully';
            return 1;
        } else {
            return 0;
        }
    }

    public function blockUser($id) {

        $updateArr = array('status' => '2');
        $supRes = User::where('id', $id)->update($updateArr);

        if ($supRes) {
            $getUserArr = DB::table('users')->where('id', '=', $id)->get();
                if ($getUserArr[0]->active == 1) {
                    $to = $getUserArr[0]->email;
                    $subject = "Your Application Denied";
                    $txt = "Your application Denied!";
                    $headers = "From: info@liquidgraphics.com" . "\r\n" . "CC: zahid@golpik.com";
                    mail($to, $subject, $txt, $headers);
                }
                 echo 'user edit successfully';
            return 1;
        } else {
            return 0;
        }
    }

    public function deleteUser($id) {
        $delete = DB::table('users')->where('id', '=', $id)->delete();

        if ($delete) {
            return 1;
        } else {
            return 0;
        }
    }

}
