<?php
namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use DB;
use App\Details;
use App\Prices;
use App\CompanyInfo;

class General extends Model
{
   
   protected $table = 'lpdGeneral';
   
   public $timestamps = false;
   
   public static function getCategory()
    {
       $Category=array();
       $Category = DB::table('lpdGeneral')->groupBy(LTRIM(RTRIM('productCategory')))->get();
       return $Category; 
    }
    
    
    public static function getCompanyInfo($company_code)
    {
       $company_info=array();
       $company_info = DB::table('lpdCompanyInfo')->where('companyID','=',$company_code)->get();
       return $company_info;
    }
    
    public static function getColorsInfo($companyName,$customerStyleNumber)
    {
       $ColorsInfo=array();
       $ColorsInfo = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->where('lpdGeneral.companyName',$companyName)
                ->where('lpdDetails.customerStyleNumber',$customerStyleNumber)
                ->groupBy('colors')->get();//->paginate(8);
       return $ColorsInfo; 
    }
   
   public static function getType()
    {
       $Type=array();
       $Type = DB::table('lpdGeneral')
               ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->groupBy(LTRIM(RTRIM('productType')))->get();
       return $Type; 
    }
    // For Listing
    public static function getStyle($Type)
    {
       $Style=array();
       
       $Style = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
                ->where('productType',$Type)->groupBy(LTRIM(RTRIM('productDetail')))->get();
       return $Style; 
    }
    
    public static function getColors($Type)
    {
       $colors=array();
       $colors = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->where('productType',$Type)->groupBy(LTRIM(RTRIM('colors')))->get();
       return $colors; 
    }
    
    public static function getBrands($Type)
    {
       $colors=array();
       $colors = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->where('productType',$Type)->whereNotNull('companyName')->groupBy(LTRIM(RTRIM('companyName')))->get();
       return $colors; 
    }
    
   public static function getFabric($Type)
    {
       $materials = array();
       $materials = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->where('productType',$Type)->groupBy(LTRIM(RTRIM('materials')))->get();
       return $materials; 
    }
    
    public static function getSizes($Type,$groupby)
    {
       $sizes = array();
       $sizes = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->where('productType',$Type)->where($groupby,'>',0)->get();
       return $sizes; 
    }
    public static function getPriceLimit($Type)
    {
        
        $price_limit = array();
        $price_limits = array();
       $price_limit = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber')
               ->select('lpdPrices.S AS s_max','lpdPrices.youthS AS ys_max')
                //->select(DB::raw('MAX(lpdPrices.S) AS s_max'), DB::raw('MIN(lpdPrices.S) AS s_min'), DB::raw('MAX(lpdPrices.youthS) AS ys_max'), DB::raw('MIN(lpdPrices.youthS) AS ys_min'))
               //->selectRaw("MAX(lpdPrices.S) AS s_max, MAX(lpdPrices.youthS) AS ys_max")
                ->where('productType',$Type)->get();
       $i=0;
       foreach($price_limit as $val){
           $s_max[$i] = floatval($val->s_max);
         $i++;  
       }
       foreach($price_limit as $val){
           $ys_max[$i] = floatval($val->ys_max);
         $i++;  
       }
      
       $price_limits['s_max']=MAX($s_max);
       $price_limits['s_min']=MIN($s_max);
       $price_limits['ys_max']=MAX($ys_max);
       $price_limits['ys_min']=MIN($ys_max);
       return $price_limits; 
    }
    
    
    // For Search
    public static function getStyleSearch($q)
    {
       $style=array();
       $key=explode("#",$q);
       $style = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber');
                if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $style = $style->where('customerStyleNumber', '=', trim($key[1]," "));
                        $style = $style->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $style = $style->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
                
                     $style= $style->groupBy(LTRIM(RTRIM('productDetail')))->get();
       return $style; 
    }
    public static function getColorsSearch($q)
    {
       
        $key=explode("#",$q);
        $colors=array();
       $colors = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber');
               
               if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $colors = $colors->where('customerStyleNumber', '=', trim($key[1]," "));
                        $colors = $colors->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $colors = $colors->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
               $colors=$colors->groupBy(LTRIM(RTRIM('colors')))->get();
               
       return $colors; 
    }
    
    public static function getBrandsSearch($q)
    {   
        $key=explode("#",$q);
       $brands=array();
       $brands = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber');
               if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $brands = $brands->where('customerStyleNumber', '=', trim($key[1]," "));
                        $brands = $brands->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $brands = $brands->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
        $brands=$brands->whereNotNull('factory')->groupBy(LTRIM(RTRIM('factory')))->get();
       return $brands; 
    }
    
   public static function getFabricSearch($q)
    {
       $key=explode("#",$q);
       $materials = array();
       $materials = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber');
                if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $materials = $materials->where('customerStyleNumber', '=', trim($key[1]," "));
                        $materials = $materials->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $materials = $materials->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
               $materials=$materials->groupBy(LTRIM(RTRIM('materials')))->get();
       return $materials; 
    }
    
    public static function getSizesSearch($q,$groupby)
    {
        $key=explode("#",$q);
        $sizes = array();
        $sizes = DB::table('lpdGeneral')
                ->join('lpdDetails', 'lpdGeneral.styleNumber', '=', 'lpdDetails.styleNumber')
                ->join('lpdPrices', 'lpdGeneral.styleNumber', '=', 'lpdPrices.styleNumber');
                if(isset($q)){
                    if(isset($key[0]) && isset($key[1]))
                    {
                        $sizes = $sizes->where('customerStyleNumber', '=', trim($key[1]," "));
                        $sizes = $sizes->where('companyName', '=',  trim($key[0]," "));

                    }else {
                        $sizes = $sizes->where(function($query){
                            $q=trim($_GET['q']," ");
                                $query->where('companyName', 'like', '%'.$q.'%')
                                    ->orWhere('customerStyleNumber', 'like', '%'.$q.'%')
                                    ->orWhere('materials', 'like', '%'.$q.'%')
                                    ->orWhere('productDetail', 'like', '%'.$q.'%')
                                    ->orWhere('lpdGeneral.styleNumber', 'like','%'.$q.'%');
                        });
                    }
                }
              $sizes=$sizes->where($groupby,'<>',$groupby)->get();
       return $sizes; 
    }
    
    
    public static function getMarkup($per,$amount,$cost)
    {
        $markup = 0;
        if($per){
            $percentage = $per;
            $price = $cost;
            $markup = ($percentage / 100) * $price;
            
        }
         
        if($amount){
            $markup = $markup +$amount; 
        }
        
        $markup = $markup + $cost;
        $markup=round($markup,2);
       return $markup; 
    }
    
    public static function getMarkupSub($per,$amount,$cost)
    {
        $markup = 0;
        $percentage=0;
        $price=0;
        if($per){
            $percentage = $per;
            $price = $cost;
            $markup = ($percentage / 100) * $price;
            
        }
         
        if($amount){
            $markup = $markup +$amount; 
        }
        
        $markup = $cost - $markup ;
        
        $markup=round($markup,2);
       return $markup; 
    }
    
    public static function clean($string) {
            $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
            $string = preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.

            return preg_replace('/-+/', '-', $string); // Replaces multiple hyphens with single one.
         }
    
   
     
}
