<?php $__env->startSection('pageheader'); ?>
Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Dashboard 
            <small>Request application</small>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content container-fluid">

        <!-- /.row -->
        <div class="row">
            <div class="col-xs-12">
                <?php if(Session::has('message')): ?> <div class="alert alert-info"> <?php echo e(Session::get('message')); ?> </div> <?php endif; ?>
                <div class="box box-info p10">
                    <div class="box-header mb20">
                        <h3 class="box-title"><strong>REQUEST APPLICATION</strong></h3>
 
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive no-padding">
                        <div class="alert alert-info" style="background-color:#3c8dbc !important;"><ul><li style="list-style:none; background:#3c8dbc">Note: After selection or input your data click on action button.</li></ul>
                     </div>
                        <table id="example" class="table table-req__app table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>User Name</th>
                                <th>User Email</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach($userInfo as $user): ?>
                            <tr>
                                <td> <?php echo e($user->id); ?>

                                <input type='hidden'  value='<?php echo e(csrf_token()); ?>' name='_token' id="_token_<?php echo e($user->id); ?>"/>
                                </td>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->created_at); ?></td>
                                <td>
                                    <?php if($user->status=='0'): ?>
                                        <span class="label label-warning">Pending</span>
                                        <?php elseif( $user->status=='1'): ?>
                                      <span class="label label-success">Approved</span>
                                        <?php elseif($user->status=='2'): ?>
                                       <span class="label label-danger">Denied</span>
                                    <?php endif; ?>
                                    <div id="load<?php echo e($user->id); ?>"></div>
                                </td>
                                 <td>
                                    <select class="select-styling" name='actionSel' id='actionSel' onChange='doAction(this.value,<?php echo e($user->id); ?>)'>
                                        <option value='0'> Select Status  </option>
                                        <option value='block'> Denied </option>
                                        <option value='active'> Approved </option>
                                        <option value='delete'> Delete </option>
                                    </select>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            
                           </tbody>
                        </table>

                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </div>








    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>

    function doAction(name, id){
        if (name == 0 || name == ''){
            return false;
        } else{
            if (name == 'delete') {
                deleteUser(id)
            } else if (name == 'edit'){
                edit(id)
            } else if (name == 'block'){
                blockUser(id)
            } else if (name == 'active'){
                active(id)
            } else{
                return false;
            }
        }
    }

    function deleteUser(id){
        if (id == 0){
            return fasle;
        }
        var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    if (this.responseText == 0){
                        alert("Userr Not deleted");
                    } else{
                        $('#load'+id).html('<p>user deleted</p>');
                        setTimeout(function() {
                        
                        window.location.reload();
                    }, 1000);
                    
                    }
                }
            };
            
            xhttp.open("GET", "<?php echo e(url('admin/deleteUser')); ?>/" + id, true);
            xhttp.send();
    }

    function blockUser(id){

        if (id == 0){
            return fasle;
        }
        
        var xhttp = new XMLHttpRequest();
        $('#load'+id).html('<div class="loader-product"><img style="img-center img-responsive height:30px" height="30px" src="<?php echo url('public/front/images/loading1.gif');?>" /></div>');
        xhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {

            if (this.responseText == 0){
                                        alert("User Not Block");
            } else{
                $('#load'+id).html('<p>user Blocked</p>');
               setTimeout(function() {
               
               window.location.reload();
               }, 1000);
                
            }
        }
        };
        xhttp.open("GET", "<?php echo e(url('admin/blockUser')); ?>/" + id, true);
        xhttp.send();
    }

    //Active User
    function active(id){
        if (id == 0){
            return fasle;
        }
        var xhttp = new XMLHttpRequest();
        $('#load'+id).html('<div class="loader-product"><img style="img-center img-responsive height:30px;" src="<?php echo url('public/front/images/loading1.gif');?>" height="30px" /></div>');
        xhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {

                if (this.responseText == 0){
                    alert("User Not Activete");
                } else{
                    $('#load'+id).html('<p>user Activate</p>');
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                    
                }

            }
        };
        xhttp.open("GET", "<?php echo e(url('admin/activeUser')); ?>/" + id, true);
        xhttp.send();
    }

    function edit(id){
        window.location = "<?php echo e(url('admin/editUser')); ?>/" + id;
    }

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.screen', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>